% -------------------------------------------------------------------
% Este script hace la figura en la que se resuelve la ecuacin para
% la descomposicin de una especie radiactiva usando el mtodo de Euler
% y el mtodo Leapfrog para el mismo tamao de paso
% Este script requiere que en el espacio de trabajo exista la
% funcin feuler y fLeapfrog.
% dy/dx = f(x,y;k) = - k*y:
% -------------------------------------------------------------------
%Definiciones y parmetros

k=1;
fun = @(t,y) -k*y;
y0=100;
t0=0;
tf=5;
Nh=10;

%Solucin usando el mtodo de Euler

[te,ye]=feuler(fun,t0,tf,y0,Nh);

%Solucin usando el mtodo Leapfrog

[tl,yl]=fLeapfrog(fun,t0,tf,y0,Nh);

%Solucin exacta

tp=0:0.1:5;
yp=y0*exp(-k*tp);

%Representamos la figura

plot(tp,yp,te,ye,'or',tl,yl,'+k');
xlabel('t');
ylabel('N');
title('Comparativa Euler-Leapfrog');
legend('Sol. exacta','Mtodo Euler','Mtodo Leapfrog');
text(2,70,'k=1, Nh=10');
